IF NOT EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.TABLES	WHERE TABLE_NAME=N'GLB_CONFIG_PRECO_RESSUP_EST_PROD')
BEGIN
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	--DROP TABLE [dbo].[GLB_CONFIG_PRECO_RESSUP_EST_PROD]
	CREATE TABLE [dbo].[GLB_CONFIG_PRECO_RESSUP_EST_PROD](
		[CD_CONFIG] [int] NOT NULL, 
		[CD_EMP] [int] NOT NULL, 
		[CD_PROD] [int] NOT NULL, 
		[VLR_TRANSF] [money] NULL,
		[CD_USU] [int] NULL,
		[DT_CAD] [datetime] NULL,
		[DT_ULT_ALT] [datetime] NULL,
	 CONSTRAINT [PK_GLB_CONFIG_PRECO_RESSUP_EST_PROD] PRIMARY KEY CLUSTERED 
	(	
		[CD_PROD] ASC,
		[CD_CONFIG] ASC

	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
	) ON [PRIMARY] 
	
	ALTER TABLE [dbo].[GLB_CONFIG_PRECO_RESSUP_EST_PROD] ADD  CONSTRAINT [DF_GLB_CONFIG_PRECO_RESSUP_EST_PROD_VLR_TRANSF]  DEFAULT ((0)) FOR [VLR_TRANSF]
	ALTER TABLE [dbo].[GLB_CONFIG_PRECO_RESSUP_EST_PROD] ADD  CONSTRAINT [DF_GLB_CONFIG_PRECO_RESSUP_EST_PROD_CD_USU]  DEFAULT ((0)) FOR [CD_USU]	

	ALTER TABLE [dbo].[GLB_CONFIG_PRECO_RESSUP_EST_PROD]  WITH CHECK ADD  CONSTRAINT [FK_GLB_CONFIG_PRECO_RESSUP_EST_PROD_EST_PROD] FOREIGN KEY([CD_EMP],[CD_PROD])
			REFERENCES [dbo].[EST_PROD] ([CD_EMP],[CD_PROD])
		ALTER TABLE [dbo].[GLB_CONFIG_PRECO_RESSUP_EST_PROD] CHECK CONSTRAINT [FK_GLB_CONFIG_PRECO_RESSUP_EST_PROD_EST_PROD]

	ALTER TABLE [dbo].[GLB_CONFIG_PRECO_RESSUP_EST_PROD]  WITH CHECK ADD  
			CONSTRAINT [FK_GLB_CONFIG_PRECO_RESSUP_EST_PROD_GLB_CONFIG_PRECO_RESSUP] FOREIGN KEY([CD_CONFIG])
			REFERENCES [dbo].[GLB_CONFIG_PRECO_RESSUP] ([CD_CONFIG])
		ALTER TABLE [dbo].[GLB_CONFIG_PRECO_RESSUP_EST_PROD] CHECK CONSTRAINT [FK_GLB_CONFIG_PRECO_RESSUP_EST_PROD_GLB_CONFIG_PRECO_RESSUP]
END


